<?php

error_reporting(E_ALL);
ini_set('display_errors', 1);

// Database configuration
$servername = "localhost"; // or your server IP
$username = "wfaridy_wfaridy";
$password = "w!L,#9V?]DMK";
$dbname = "wfaridy_db000000010001";

// Create connection
$conn = new mysqli($servername, $username, $password, $dbname);

// Check connection
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

// Check if fields are set in the GET request
if (isset($_GET['frame'])) {
    $frame = $_GET['frame'];

    // Step 2: Parse the comma-separated values from the 'frame' parameter
    $frameValues = explode(',', $frame);
    
    // Make sure there are exactly 5 values: trno, qty, rodid, ts, utr
    if (count($frameValues) == 5) {
        $trno = (int)$frameValues[0];  // First value - trno
        $qty = (int)$frameValues[1];   // Second value - qty
        $rodid = (int)$frameValues[2]; // Third value - rodid
        $ts = $frameValues[3];    // Fourth value - timestamp (ts)
        $utr = (int)$frameValues[4];    // Fifth value - utr
        $nozzID = $rodid % 100 ;
        $rodid = intval($rodid/100) ;

        $ts = str_replace('/', '-', $ts);

        // Step 4: Insert the data into the database
        $sql = "INSERT INTO transactions_tbl (trno, qty, rodid, nozzid, ts, utr) VALUES (?, ?, ?, ?, ?, ?)";
        
        // Prepare the SQL statement
        if ($stmt = $conn->prepare($sql)) {
            // Bind the parameters to the SQL query
            $stmt->bind_param("iiiisi", $trno, $qty, $rodid, $nozzID, $ts, $utr);
            
            // Execute the statement
            if ($stmt->execute()) {
                echo "Trans inserted.";
            } else {
                echo "Error: " . $stmt->error;
            }

            // Close the statement
            $stmt->close();
        } else {
            echo "Error preparing statement: " . $conn->error;
        }
		///////////////////////////////////////////////
        // Step 5: Update the data into the database
        
        $qtyLtr = $qty/1000.0 ;
        
		if ($nozzID == 1)
			$query = "UPDATE dispensers_tbl SET nozzle1_fuel_disp = nozzle1_fuel_disp + ?, nozzle1_last_tr_ts = ? WHERE rodid = ?";
		elseif ($nozzID == 2)
			$query = "UPDATE dispensers_tbl SET nozzle2_fuel_disp = nozzle2_fuel_disp + ?, nozzle2_last_tr_ts = ? WHERE rodid = ?";
		elseif ($nozzID == 3)
			$query = "UPDATE dispensers_tbl SET nozzle3_fuel_disp = nozzle3_fuel_disp + ?, nozzle3_last_tr_ts = ? WHERE rodid = ?";
		elseif ($nozzID == 4)
			$query = "UPDATE dispensers_tbl SET nozzle4_fuel_disp = nozzle4_fuel_disp + ?, nozzle4_last_tr_ts = ? WHERE rodid = ?";

		// Prepare the statement
		$stmt2 = $conn->prepare($query);

		// Bind the parameters to the placeholders
		$stmt2->bind_param("dsi", $qtyLtr, $ts, $rodid);  // "i" for integer, "s" for string

		// Execute the statement
		$stmt2->execute();

		// Check for errors
		if ($stmt2->affected_rows > 0) {
			echo "Dispensers updated.";
		} else {
			echo "Not updated.";
		}

		// Close the statement and connection
		$stmt2->close();
		
		///////////////////////////////////////////////
        // Step 6: Close the database connection
        $conn->close();
    } else {
        echo "Invalid frame parameter format.";
    }
} else {
    echo "No frame parameter provided.";
}

?>